'use strict';

function TeachersCtrl($scope, $rootScope, $http, $timeout, AppConfig){
    $scope.newTeacher = {
        firstname:  '',
        lastname:   '',
        email:      ''
    };

    $scope.createTeacher = function(){
        var message = {
            title: 'Tworzenie konta nauczyciela'
            ,msg: 'Trwa tworzenie konta nauczyciela'
        };
        $rootScope.$broadcast('Message:addMsg', message);

        $http.post(AppConfig.urlTeachersAccounts, $scope.newTeacher)
            .success(function(data){
                $rootScope.$broadcast('Message:delMsg', message);

                if(typeof data.error != 'undefined')
                {
                    $rootScope.$broadcast('Message:error', data.error);
                }
                else
                {
                    var successMessage = {
                        title: 'Tworzenie konta nauczyciela'
                        ,msg: 'Poprawnie utworzono nauczyciela ' + $scope.newTeacher.firstname + " " + $scope.newTeacher.lastname
                    };
                    $scope.newTeacher = {
                        firstname:  '',
                        lastname:   '',
                        email:      ''
                    };
                    $timeout(function(){
                        $rootScope.$broadcast('Message:addMsg', successMessage);
                    }, 500);

                    $timeout(function(){
                        $rootScope.$broadcast('Message:delMsg', successMessage);
                    }, 3500);
                }
            })
            .error(function(data){
                $rootScope.$broadcast('Message:delMsg', message);
                $rootScope.$broadcast('Message:error', data);
            })
        ;
    };
}

TeachersCtrl.$inject = ['$scope', '$rootScope', '$http', '$timeout', 'AppConfig'];